const URI = 'https://bisque-turkey-303727.hostingersite.com/Nadeen/adminPanel/adminController.php'
$(document).ready(function () {
    drawUsersTable();
});


function drawUsersTable() {
    // table initat
    _tableUsersDetails = $('#usersTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excelHtml5',
                title: 'Visits Details'
            },
            {
                extend: 'pdfHtml5',
                title: 'Visits Details'
            }
        ],
        proccessing: true,
        searching: true,
        lengthChange: false,
        serverSide: false,
        // ajax request
        ajax: {
            url: URI + '?action=getHRs',
            type: "POST",
            data: {},
        },

        order: [],
        // table columns
        columns: [
            {
                orderable: true,
                // column header name
                title: 'Job ID',
                render: function (data, type, row) {
                    // jobID name sent from the backend
                    return row.jobID;
                }
            },
            {
                orderable: true,
                title: 'User Name',
                render: function (data, type, row) {
                    return row.user_name;
                }
            },
            {
                orderable: true,
                title: 'Position',
                render: function (data, type, row) {
                    return row.position;
                }
            },
            {
                orderable: true,
                title: 'Email',
                render: function (data, type, row) {
                    return row.email;
                }
            },
            {
                orderable: true,
                title: 'Phone Number',
                render: function (data, type, row) {
                    return row.phone_number;
                }
            },
            {
                orderable: true,
                title: 'Action',
                render: function (data, type, row) {
                    // create the approve and reject buttons
                    return '<button style = "margin: 3px;" id="' + row.jobID + '" type="button" class="btn btn-success approveBtn">Approve</button>' +
                        '<button id = "' + row.jobID + '" type="button" class="btn btn-danger deleteBtn">Reject</button>';


                }
            }
        ],
    });
}




// this function will execute when the reject button is clicked
$(document).on("click", ".deleteBtn", function () {
    var deleteId = $(this).attr('id');
    const child = document.getElementById(deleteId);
    // ajax request
    $.ajax({
        type: "POST",
        url: URI + '?action=deleteUser',
        data: { deleteId: deleteId },
        success: function (response) {
            if (response == 'deleted') {
                // remove the row from the table
                child.parentElement.parentElement.remove();
                // show the success message
                $("#successMsg").css("display", "block");
            } else {
                $("#failMsg").css("display", "block");
            }
        }
    });
});

// this function will execute when the approve button is clicked
$(document).on("click", ".approveBtn", function () {
    var ApproveId = $(this).attr('id');
    const child = document.getElementById(ApproveId);

    $.ajax({
        type: "POST",
        url: URI + '?action=approveUser',
        data: { ApproveId: ApproveId },
        success: function (response) {
            if (response == 'approved') {
                //remove row from table so admin would approve or reject hr
                child.parentElement.parentElement.remove();
                // show the success message
                $("#approveMsgSuccess").css("display", "block");
            } else {
                $("#approveMsgFail").css("display", "block");
            }
        }
    });
});
