const URI = "https://nadinegp2.000webhostapp.com/Nadeen/HR/hrController.php";

$(document).ready(function () {
    
    if(window.location.href.includes('inActiveUsers.php') == false){
        getUserInfo();
        getTimeSheetData();
        getPositions()
    }
});

$("#editBtn").click(function (e) {
    e.preventDefault();
    var userID = $("#userID").val();
    var position = $("#position").val();

    $.ajax({
        type: "POST",
        url: URI + '?action=updateUserPosition',
        data: {
            userID: userID,
            position: position
        },
        success: function (response) {
            if (response == 'Updated') {
                Swal.fire({
                    icon: 'success',
                    title: 'Great',
                    text: 'User position has been updated successfully!',
                    confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
                })
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'an error occurred please try again!',
                    confirmButtonText: 'Ok',
              confirmButtonColor: 'red',
                })
            }
        }
    });

});

function getUserInfo() {
    var userId = $("#userID").val();
    $.ajax({
        type: "POST",
        url: URI + '?action=getUserInfo',
        data: { userId: userId },
        dataType: "JSON",
        success: function (response) {
            $("#lastName").val(response.data[0].last_name);
            $("#userName").val(response.data[0].user_name);
            $("#firstName").val(response.data[0].first_name);
            $("#position").val(response.data[0].position);
            $("#gender").val(response.data[0].gender);
            $("#email").val(response.data[0].email);
            $("#personalId").attr('href', 'https://nadinegp2.000webhostapp.com/Nadeen/Signup/' + response.data[0].personal_id + '');
            $("#nonCrime").attr('href', 'https://nadinegp2.000webhostapp.com/Nadeen/Signup/' + response.data[0].nonCrime + '');
            $("#pasport").attr('href', 'https://nadinegp2.000webhostapp.com/Nadeen/Signup/' + response.data[0].pasport + '');
            $("#uni_cert").attr('href', 'https://nadinegp2.000webhostapp.com/Nadeen/Signup/' + response.data[0].uni_cert + '');
            $("#medical_cert").attr('href', 'https://nadinegp2.000webhostapp.com/Nadeen/Signup/' + response.data[0].medical_cert + '');
            $("#iban").attr('href', 'https://nadinegp2.000webhostapp.com/Nadeen/Signup/' + response.data[0].iban + '');

            $("#cv").attr('href', 'https://nadinegp2.000webhostapp.com/Nadeen/Signup/' + response.data[0].cv + '')
            if (!response.data[0].other) {
                $("#other").replaceWith('<span>no File attached</span>')
            } else {
                $("#other").attr('href', 'https://nadinegp2.000webhostapp.com/Nadeen/Signup/' + response.data[0].other + '');

            }
            if (!response.data[0].reco_letter) {
                $("#reco_letter").replaceWith('<span>no File attached</span>')
            } else {
                $("#reco_letter").attr('href', 'https://nadinegp2.000webhostapp.com/Nadeen/Signup/' + response.data[0].reco_letter + '')
            }
        }
    });
}
function getTimeSheetData(){
     var userId = $("#userID").val();
     var timeSheetDiv = $("#timeSheetDiv")
      $.ajax({
        type: "POST",
        url: URI + '?action=getTimeSheetData',
        data: { userId: userId },
        dataType: "JSON",
        success: function (response) {
            var data = response.data;
            if(response.data.length > 0){
                
                
                 data.forEach(element => {

                        timeSheetDiv.append(`<div class="card text-center" style="margin-top:10px">
                  <div class="card-header">
                   ${element.user_name}
                  </div>
                  <div class="card-body">
                    <h5 class="card-title">Tasks</h5>
                    <p class="card-text">${element.tasks}</p>
                  </div>
                  <div class="card-footer text-muted">
                    ${element.date}
                  </div>
                </div>
`)
                });
                $('#timsheetMainDiv').css('display','block');
            }
        }
    });
}

function getPositions(){
    var Position_Select = $("#positionSelect")
    $.ajax({
        type: "POST",
        url: URI+'?action=getPositions',
        dataType: "JSON",
        success: function (response) {
            data = response.data;
            data.forEach(element => {
                Position_Select.append(`<option value="${element.id}">${element.name}</option>`)
            });
        }
    });
}

$("#changeBtn").click(function(){
    
        var positionsData = [];
        var selectedOptions = $("#positionSelect").find(":selected");
        for (let i = 0; i < Object.keys(selectedOptions).length; i++) {
            
            if (selectedOptions[i]) {
                positionsData.push(selectedOptions[i].value);
            }
        }
        
        var userId = $("#userID").val();

        if($('#nda').is(':checked') && positionsData.length && $('#Guidlines').is(':checked') && $('#jobOffer').is(':checked') ){
            var submitData = {};
            submitData['userID'] = userId;
            submitData['position'] = positionsData[0]

            $.ajax({
                type: "POST",
                url: URI + '?action=updateUserPosition',
                data: submitData,
                dataType: 'json', // payload is json
                async:false,
                success: function (response) {
                    if (response.data == 'Updated') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Great',
                            text: 'User position has been updated successfully!',
                            confirmButtonText: 'Ok',
                            confirmButtonColor: 'red',
                        })
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'an error occurred please try again!',
                            confirmButtonText: 'Ok',
                            confirmButtonColor: 'red',
                        })
                    }
                }
            });
        }else{
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Please check all the feilds!',
                confirmButtonText: 'Ok',
                confirmButtonColor: 'red',
            })
        }
})