const URI = "https://nadinegp2.000webhostapp.com/Nadeen/Home/homeController.php";
$(document).ready(function () {
    getApprovalStatus();
    drawTable();
})
$("#approveBtn").click(function () {
    if ($('#readCheckbox').is(':checked') && $("#sig-dataUrl").val()) {
        $.ajax({
            type: "POST",
            url: URI + '?action=ApproveTerms',
            data: {
                status: 'Approved',
                userId: $("#loginUserId").val(),
                signture: $("#sig-dataUrl").val()
            },
            success: function (response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Great',
                    text: 'You Have Approved the Terms !',
                    confirmButtonText: 'Ok',
                    confirmButtonColor: 'red',
                }).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            }
        });
    } else {
        alert("Please approve and sign before submitting");
    }
})
function getApprovalStatus() {
    $.ajax({
        type: "POST",
        url: URI + '?action=getApprovalStatus',
        success: function (response) {
            if (response == 'user Approved') {
                $("#approveDiv").css('display', 'none');
            }
        }
    });
}
// the following go will execute when the user click on the submit button "timesheet page"
$("#submitTimesheetBtn").click(function () {
    // ajax request
    $.ajax({
        type: "POST",
        url: URI + '?action=submitTimeSheet',
        data: {
            date: $("#date").val(),
            tasks: $("#myTasks").val(),
            userId: $("userId").val()
        },
        success: function (response) {
            // check the response recived from the backend and show alert foreach response
            if (response == 'submitted') {
                Swal.fire({
                    icon: 'success',
                    title: 'Great',
                    text: 'Timesheet for the day submitted sucessfully!',
                    confirmButtonText: 'Ok',
                    confirmButtonColor: 'red',
                    confirmButtonText: 'Ok',
                }).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            } else if (response == 'year wrong') {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops',
                    text: 'The year should atleast be 2022',
                    confirmButtonText: 'Ok',
                    confirmButtonColor: 'red',
                    confirmButtonText: 'Ok',
                })
            } else if (response == 'month wrong') {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops',
                    text: 'The mount should atleast be 10',
                    confirmButtonText: 'Ok',
                    confirmButtonColor: 'red',
                    confirmButtonText: 'Ok',
                })
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops',
                    text: 'Please fill all the feilds!',
                    confirmButtonText: 'Ok',
                    confirmButtonColor: 'red',
                    confirmButtonText: 'Ok',
                })
            }
        }
    });
})

function drawTable() {
    // create the table
    $('#timesheettable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excelHtml5',
                title: 'Visits Details'
            },
            {
                extend: 'pdfHtml5',
                title: 'Visits Details'
            }
        ],
        proccessing: true,
        searching: true,
        lengthChange: false,
        serverSide: false,
        // ajax request
        ajax: {
            url: URI + '?action=getMyTimeSheet',
            type: "POST",
        },

        order: [],
        // table columns
        columns: [
            {
                orderable: true,
                title: 'Tasks',
                render: function (data, type, row) {
                    return row.tasks;
                }
            },
            {
                orderable: true,
                title: 'Date',
                render: function (data, type, row) {
                    return row.date;
                }
            }
        ],
    });
}
// signture javascript code
window.requestAnimFrame = (function (callback) {
    return window.requestAnimationFrame ||
        window.webkitRequestAnimationFrame ||
        window.mozRequestAnimationFrame ||
        window.oRequestAnimationFrame ||
        window.msRequestAnimaitonFrame ||
        function (callback) {
            window.setTimeout(callback, 1000 / 60);
        };
})();

var canvas = document.getElementById("sig-canvas");
var ctx = canvas.getContext("2d");
ctx.strokeStyle = "#222222";
ctx.lineWidth = 4;

var drawing = false;
var mousePos = {
    x: 0,
    y: 0
};
var lastPos = mousePos;

canvas.addEventListener("mousedown", function (e) {
    drawing = true;
    lastPos = getMousePos(canvas, e);
}, false);

canvas.addEventListener("mouseup", function (e) {
    drawing = false;
}, false);

canvas.addEventListener("mousemove", function (e) {
    mousePos = getMousePos(canvas, e);
}, false);

// Add touch event support for mobile
canvas.addEventListener("touchstart", function (e) {

}, false);

canvas.addEventListener("touchmove", function (e) {
    var touch = e.touches[0];
    var me = new MouseEvent("mousemove", {
        clientX: touch.clientX,
        clientY: touch.clientY
    });
    canvas.dispatchEvent(me);
}, false);

canvas.addEventListener("touchstart", function (e) {
    mousePos = getTouchPos(canvas, e);
    var touch = e.touches[0];
    var me = new MouseEvent("mousedown", {
        clientX: touch.clientX,
        clientY: touch.clientY
    });
    canvas.dispatchEvent(me);
}, false);

canvas.addEventListener("touchend", function (e) {
    var me = new MouseEvent("mouseup", {});
    canvas.dispatchEvent(me);
}, false);

function getMousePos(canvasDom, mouseEvent) {
    var rect = canvasDom.getBoundingClientRect();
    return {
        x: mouseEvent.clientX - rect.left,
        y: mouseEvent.clientY - rect.top
    }
}

function getTouchPos(canvasDom, touchEvent) {
    var rect = canvasDom.getBoundingClientRect();
    return {
        x: touchEvent.touches[0].clientX - rect.left,
        y: touchEvent.touches[0].clientY - rect.top
    }
}

function renderCanvas() {
    if (drawing) {
        ctx.moveTo(lastPos.x, lastPos.y);
        ctx.lineTo(mousePos.x, mousePos.y);
        ctx.stroke();
        lastPos = mousePos;
    }
}

// Prevent scrolling when touching the canvas
document.body.addEventListener("touchstart", function (e) {
    if (e.target == canvas) {
        e.preventDefault();
    }
}, false);
document.body.addEventListener("touchend", function (e) {
    if (e.target == canvas) {
        e.preventDefault();
    }
}, false);
document.body.addEventListener("touchmove", function (e) {
    if (e.target == canvas) {
        e.preventDefault();
    }
}, false);

(function drawLoop() {
    requestAnimFrame(drawLoop);
    renderCanvas();
})();

function clearCanvas() {
    canvas.width = canvas.width;
}

// Set up the UI
var sigText = document.getElementById("sig-dataUrl");
var sigImage = document.getElementById("sig-image");
var clearBtn = document.getElementById("sig-clearBtn");
var submitBtn = document.getElementById("sig-submitBtn");
clearBtn.addEventListener("click", function (e) {
    clearCanvas();
    sigText.innerHTML = "Data URL for your signature will go here!";
    sigImage.setAttribute("src", "");
}, false);
submitBtn.addEventListener("click", function (e) {
    var dataUrl = canvas.toDataURL();
    sigText.innerHTML = dataUrl;
    sigImage.setAttribute("src", dataUrl);

}, false);
// end of the signture backend code