const URI = "../HR/hrController.php";
document.getElementById("addBtn").addEventListener("click", function () {
  const repeater = document.getElementById("repeater");

  // clone the first item
  let clone = repeater.children[0].cloneNode(true);

  // clear the input value
  clone.querySelector("textArea").value = "";

  // append the cloned item
  repeater.appendChild(clone);
});

function removeItem(button) {
  const repeater = document.getElementById("repeater");

  // prevent removing the last one
  if (repeater.children.length > 1) {
    button.parentElement.remove();
  }
}
document.querySelector("#myForm").addEventListener("submit", function (e) {
  e.preventDefault();

  const formData = new FormData();

  const userID = document.getElementById("userID").value.trim();
  formData.append("userID", userID);

  const rows = document.querySelectorAll("#repeater .item");

  rows.forEach((row, index) => {
    formData.append(`result[${index}][objective]`,
      row.querySelector('textarea[name="field[]"]').value
    );

    formData.append(`result[${index}][comments]`,
      row.querySelector('textarea[name="comments[]"]').value
    );

    formData.append(`result[${index}][month]`,
      row.querySelector('select[name="month[]"]').value
    );

    formData.append(`result[${index}][year]`,
      row.querySelector('select[name="year[]"]').value
    );

    // File (optional)
    const fileInput = row.querySelector('input[type="file"]');
    if (fileInput && fileInput.files.length > 0) {
      formData.append(`result[${index}][file]`, fileInput.files[0]);
    }
  });

  $.ajax({
    type: "POST",
    url: URI + "?action=setUserObjectives",
    data: formData,
    processData: false, // REQUIRED
    contentType: false, // REQUIRED
    dataType: "JSON",
    success: function (response) {
      if (response.data === 'done') {
        Swal.fire({
          icon: 'success',
          title: 'Great',
          text: 'Objectives added',
          confirmButtonColor: 'red'
        });
      } else {
        Swal.fire({
          icon: 'error',
          title: 'Oops...',
          text: 'An error occurred, please try again!',
          confirmButtonColor: 'red'
        });
      }
    }
  });
});
