const URI = "../HR/hrController.php";
var _tableUsersDetails,_jobsTable,_jobsDstailsTable;
var positionFilter = '';
var flag = '';
$(document).ready(function () {
    
    
    $("#submit").click(function(){
      var jobTitle = $("#jobTitle").val();
      var Location = $("#Location").val();
      var description = $("#description").val();
      var YearsOfExperiance = $("#YearsOfExperiance").val();
      
       $.ajax({
            type: "POST",
            url: URI+'?action=postaJob',
            data: {jobTitle,Location,description,YearsOfExperiance},
            success: function (response) {
                if(response == 'Posted'){
                    child.parentElement.parentElement.remove();
                    $("#successMsg").css("display","block");
                }else{
                    $("#failMsg").css("display","block");
                }
            }
        });
    });
    
    getPositions();
    if(window.location.href.includes('inActiveUsers.php') || window.location.href.includes('InActiveUsers.php')){
        flag = 'InActive';
    }
    drawUsersTable();    
    drawJobsTable();   
    drawJobsDetailsTable();   
});
function drawUsersTable() {
    _tableUsersDetails = $('#usersTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excelHtml5',
                title: 'Visits Details'
            },
            {
                extend: 'pdfHtml5',
                title: 'Visits Details'
            }
        ],
        proccessing: true,
        searching: true,
        lengthChange: false,
        serverSide: false,
        ajax: {
            url: URI + '?action=getUsers',
            type: "POST",
            data:{
                positions: function () {
                    var positionsData = [];
                    var selectedOptions = $("#positionSelect").find(":selected");
                
                    for (let i = 0; i < Object.keys(selectedOptions).length; i++) {
                        
                        if (selectedOptions[i]) {
                            positionsData.push(selectedOptions[i].value);
                        }
                    }
                    return positionsData;
                },
                age: function () {
                    var ageData = [];
                    var selectedOptions = $("#ageSelect").find(":selected");
                
                    for (let i = 0; i < Object.keys(selectedOptions).length; i++) {
                        
                        if (selectedOptions[i]) {
                            ageData.push(selectedOptions[i].value);
                        }
                    }
                    return ageData;
                },
                flag:flag
            },
        },
       
        order: [],
        columns: [
            {
                orderable: true,
                title: 'Job ID',
                render: function (data, type, row) {
                    return row.jobID;
                }
            },
            {
                orderable: true,
                title: 'User Name',
                render: function (data, type, row) {
                    return row.user_name.charAt(0).toUpperCase() + row.user_name.slice(1); ;
                }
            },
            {
                orderable: true,
                title: 'Position',
                render: function (data, type, row) {
                    return row.position;
                }
            },
            {
                orderable: true,
                title: 'Email',
                render: function (data, type, row) {
                    return row.email;
                }
            },
            {
                orderable: true,
                title: 'Phone Number',
                render: function (data, type, row) {
                    return row.phone_number;
                }
            },
        
            
            {
                orderable: true,
                title: 'Action',
                render: function (data, type, row) {
                    var buttons = '';
                    if(row.status == 'Active'){
                        buttons+= '<a style = "margin: 3px;" href="../HR/setObjectives.php?userId='+row.jobID+'" target="_blank"><button type="button" class="btn btn-success">Set Objectives</button></a>';
                        buttons+= '<a style = "margin: 3px;" href="../HR/viewObjectives.php?userId='+row.jobID+'" target="_blank"><button type="button" class="btn btn-secondary">View Objectives</button></a>';

                    }
                    if(!flag){
                        buttons+='<a style = "margin: 3px;" href="../HR/userInfo.php?userId='+row.jobID+'" target="_blank"><button type="button" class="btn btn-info">More info</button></a>'+
                        '<a style = "margin: 3px;" href="../HR/changePositions.php?userId='+row.jobID+'" target="_blank"><button type="button" class="btn btn-warning">Change Position</button></a>'+
                        '<button id = "'+row.jobID+'" type="button" class="btn btn-danger deleteBtn">Delete</button>';
                    }else{
                        buttons+= '<button style = "margin: 3px;" id="'+row.jobID+'" type="button" class="btn btn-success approveBtn">Approve</button>'+
                        '<button id = "'+row.jobID+'" type="button" class="btn btn-danger deleteBtn">Reject</button>';
                    }
                    return buttons;
                }
            }
        ],
    });
}
function drawJobsTable() {
    _jobsTable = $('#jobsTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excelHtml5',
                title: 'Jobs Details'
            },
            {
                extend: 'pdfHtml5',
                title: 'Jobs Details'
            }
        ],
        proccessing: true,
        searching: true,
        lengthChange: false,
        serverSide: false,
        ajax: {
            url: URI + '?action=getJobs',
            type: "POST",
        },
       
        order: [],
        columns: [
            {
                orderable: true,
                title: 'Job ID',
                render: function (data, type, row) {
                    return row.id;
                }
            },
            {
                orderable: true,
                title: 'Job title',
                render: function (data, type, row) {
                    return row.jobTitle
                }
            },
            {
                orderable: true,
                title: 'Years Of Experiance',
                render: function (data, type, row) {
                    return row.yearsOfExperiance;
                }
            },
            {
                orderable: true,
                title: 'Location',
                render: function (data, type, row) {
                    return row.location;
                }
            },
            {
                orderable: true,
                title: 'Description',
                render: function (data, type, row) {
                    return row.description;
                }
            }
        ],
    });
}
function drawJobsDetailsTable() {
    _jobsDstailsTable = $('#jobsDetails').DataTable({
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excelHtml5',
                title: 'Jobs Details'
            },
            {
                extend: 'pdfHtml5',
                title: 'Jobs Details'
            }
        ],
        proccessing: true,
        searching: true,
        lengthChange: false,
        serverSide: false,
        ajax: {
            url: URI + '?action=getJobs',
            type: "POST",
        },
       
        order: [],
        columns: [
            {
                orderable: true,
                title: 'Job ID',
                render: function (data, type, row) {
                    return row.id;
                }
            },
            {
                orderable: true,
                title: 'Job title',
                render: function (data, type, row) {
                    return row.jobTitle
                }
            },
            {
                orderable: true,
                title: 'Years Of Experiance',
                render: function (data, type, row) {
                    return row.yearsOfExperiance;
                }
            },
            {
                orderable: true,
                title: 'Location',
                render: function (data, type, row) {
                    return row.location;
                }
            },
            {
                orderable: true,
                title: 'Description',
                render: function (data, type, row) {
                    return row.description;
                }
            },
            {
                orderable: true,
                title: 'Actions',
                render: function (data, type, row) {
                    return `<button class = "../Recruiter/application.php?jobID=${row.id}"><a href="">Apply</</button>`;
                }
            }
        ],
    });
}

$(document).on("click",".deleteBtn",function() {
      let text = "Are you sure you want to delete the employee ?";
  if (confirm(text) == true) {
    var deleteId = $(this).attr('id');
    const child = document.getElementById(deleteId);
    

    $.ajax({
        type: "POST",
        url: URI+'?action=deleteUser',
        data: {deleteId:deleteId},
        success: function (response) {
            if(response == 'deleted'){
                child.parentElement.parentElement.remove();
                $("#successMsg").css("display","block");
            }else{
                $("#failMsg").css("display","block");
            }
        }
    });  } 
    
});


$(document).on("click",".approveBtn",function() {
    var ApproveId = $(this).attr('id');
    const child = document.getElementById(ApproveId);
    

    $.ajax({
        type: "POST",
        url: URI+'?action=approveUser',
        data: {ApproveId:ApproveId},
        success: function (response) {
            if(response == 'approved'){
                child.parentElement.parentElement.remove();
                $("#approveMsgSuccess").css("display","block");
            }else{
                $("#approveMsgFail").css("display","block");
            }
        }
    });
});





$(document).on("click",".rateBtn",function() {
    var rateId = $(this).attr('id');
    $("#saveRateButton").attr('data-id',rateId)
});

// 

function getPositions(){
    var Position_Select = $("#positionSelect")
    $.ajax({
        type: "POST",
        url: URI+'?action=getPositions',
        dataType: "JSON",
        success: function (response) {
            data = response.data;
            data.forEach(element => {
                Position_Select.append(`<option value="${element.id}">${element.name}</option>`)
            });
        }
    });
}

$('#searcBtn').click(function (e) { 
    e.preventDefault();
    _tableUsersDetails.ajax.reload();
});
$("#saveRateButton").click(function(){
    var userid = $(this).attr('data-id');
    var rating = 0 ;

    if($('#rating-1').is(':checked')){
        rating = 1;
    }
    if($('#rating-2').is(':checked')){
        rating = 2;
    }
    if($('#rating-3').is(':checked')){
        rating = 3;
    }
    if($('#rating-4').is(':checked')){
        rating = 4;
    }
    if($('#rating-5').is(':checked')){
        rating = 5;
    }
    $.ajax({
        type: "POST",
        url: URI+'?action=rateEmployee',
        data:{rating:rating, userid:userid},
        success: function (response) {
            if(response == 'success'){
                if(confirm('success')){
                    location.reload();
                }else{
                    location.reload();
                }
            }
        }
    });
    console.log(rating);

})
