const URI = "../HR/hrController.php";
var table;
$(document).ready(function () {
    $(document).on("click",".rateBtn",function() {
        var rateId = $(this).attr('id');
        $("#saveRateButton").attr('data-id',rateId)
    });
    drawTable();
    $('#usersSelect').select2();
    getUsers();
});


function getUsers(){
    var users_Select = $("#usersSelect");

    $.ajax({
        type: "POST",
        url: URI+'?action=getUsersSelect',
        dataType: "JSON",
        success: function (response) {
            data = response.data;
            data.forEach(element => {
                users_Select.append(`<option value="${element.id}">${element.user_name}</option>`)
            });
        }
    });
}

$("#searchBtn").click(function(){
    table.ajax.reload();
})
function drawTable(){
    table = $('#timesheettable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excelHtml5',
                title: 'Visits Details'
            },
            {
                extend: 'pdfHtml5',
                title: 'Visits Details'
            }
        ],
        proccessing: true,
        searching: true,
        lengthChange: false,
        serverSide: false,
        ajax: {
            url: URI + '?action=getTimeSheet',
            type: "POST",
            data:{
                users: function () {
                    var usersData = [];
                    var selectedOptions = $("#usersSelect").find(":selected");
                
                    for (let i = 0; i < Object.keys(selectedOptions).length; i++) {
                        
                        if (selectedOptions[i]) {
                            usersData.push(selectedOptions[i].value);
                        }
                    }
                    return usersData;
                },
            }
        },
       
        order: [],
        columns: [
            {
                orderable: true,
                title: 'User Name',
                render: function (data, type, row) {
                    return row.user_name;
                }
            },
            {
                orderable: true,
                title: 'Tasks',
                render: function (data, type, row) {
                    return row.tasks;
                }
            },
            {
                orderable: true,
                title: 'Date',
                render: function (data, type, row) {
                    return row.date;
                }
            },
            {
                orderable: true,
                title: 'Date',
                render: function (data, type, row) {
                    return '<button style = "margin: 3px;" type="button" class="btn btn-success rateBtn" data-toggle="modal" id = "'+row.id+'" data-target="#ratemodal"> Rates </button>';
                }
            }
            // 
        ],
    });
} 