<?php
session_start();
if (!isset($_SESSION['id'])) {
    header('Location: ../Login/');
} 
require('../connection.php');


$query = "SELECT users.user_name, objectives.* FROM objectives
LEFT JOIN users ON(
    users.id = userid
)
WHERE userid = '".$_GET['userId']."'";
$result = $conn->query($query);


?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Objectives</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link href="css/styles.css" rel="stylesheet" />
    <script src="https://use.fontawesome.com/releases/v6.1.0/js/all.js" crossorigin="anonymous"></script>
    <script src="https://use.fontawesome.com/releases/v6.1.0/js/all.js" crossorigin="anonymous"></script>
    <style>
        .item {
            display: flex;
            align-items: center;
            gap: 10px;
            margin: 20px;
        }

        .item input {
            flex: 1; /* makes the input expand */
        }

        .removeBtn {
            margin-left: auto; /* pushes button to the right */
        }
        @media (min-width: 1025px) {
            .h-custom {
                height: 100vh !important;
            }
        }

        .card-registration .select-input.form-control[readonly]:not([disabled]) {
            font-size: 1rem;
            line-height: 2.15;
            padding-left: .75em;
            padding-right: .75em;
        }

        .card-registration .select-arrow {
            top: 13px;
        }

        .gradient-custom-2 {
            /* fallback for old browsers */
            background: #a1c4fd;

            /* Chrome 10-25, Safari 5.1-6 */
            background: -webkit-linear-gradient(to right, rgba(161, 196, 253, 1), rgba(194, 233, 251, 1));

            /* W3C, IE 10+/ Edge, Firefox 16+, Chrome 26+, Opera 12+, Safari 7+ */
            background: linear-gradient(to right, rgba(161, 196, 253, 1), rgba(194, 233, 251, 1))
        }

        .bg-indigo {
            background-color: #4835d4;
        }

        @media (min-width: 992px) {
            .card-registration-2 .bg-indigo {
                border-top-right-radius: 15px;
                border-bottom-right-radius: 15px;
            }
        }

        @media (max-width: 991px) {
            .card-registration-2 .bg-indigo {
                border-bottom-left-radius: 15px;
                border-bottom-right-radius: 15px;
            }
        }

        * {
            box-sizing: border-box;
        }

        .container {
            background-image: url("https://www.toptal.com/designers/subtlepatterns/patterns/concrete-texture.png");
            display: flex;
            flex-wrap: wrap;
            height: 100vh;
            align-items: center;
            justify-content: center;
            padding: 0 20px;
        }

        .rating {
            display: flex;
            width: 100%;
            justify-content: center;
            overflow: hidden;
            flex-direction: row-reverse;
            height: 150px;
            position: relative;
        }

        .rating-0 {
            filter: grayscale(100%);
        }

        .rating>input {
            display: none;
        }

        .rating>label {
            cursor: pointer;
            width: 40px;
            height: 40px;
            margin-top: auto;
            background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' width='126.729' height='126.73'%3e%3cpath fill='%23e3e3e3' d='M121.215 44.212l-34.899-3.3c-2.2-.2-4.101-1.6-5-3.7l-12.5-30.3c-2-5-9.101-5-11.101 0l-12.4 30.3c-.8 2.1-2.8 3.5-5 3.7l-34.9 3.3c-5.2.5-7.3 7-3.4 10.5l26.3 23.1c1.7 1.5 2.4 3.7 1.9 5.9l-7.9 32.399c-1.2 5.101 4.3 9.3 8.9 6.601l29.1-17.101c1.9-1.1 4.2-1.1 6.1 0l29.101 17.101c4.6 2.699 10.1-1.4 8.899-6.601l-7.8-32.399c-.5-2.2.2-4.4 1.9-5.9l26.3-23.1c3.8-3.5 1.6-10-3.6-10.5z'/%3e%3c/svg%3e");
            background-repeat: no-repeat;
            background-position: center;
            background-size: 76%;
            transition: .3s;
        }

        .rating>input:checked~label,
        .rating>input:checked~label~label {
            background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' width='126.729' height='126.73'%3e%3cpath fill='%23fcd93a' d='M121.215 44.212l-34.899-3.3c-2.2-.2-4.101-1.6-5-3.7l-12.5-30.3c-2-5-9.101-5-11.101 0l-12.4 30.3c-.8 2.1-2.8 3.5-5 3.7l-34.9 3.3c-5.2.5-7.3 7-3.4 10.5l26.3 23.1c1.7 1.5 2.4 3.7 1.9 5.9l-7.9 32.399c-1.2 5.101 4.3 9.3 8.9 6.601l29.1-17.101c1.9-1.1 4.2-1.1 6.1 0l29.101 17.101c4.6 2.699 10.1-1.4 8.899-6.601l-7.8-32.399c-.5-2.2.2-4.4 1.9-5.9l26.3-23.1c3.8-3.5 1.6-10-3.6-10.5z'/%3e%3c/svg%3e");
        }


        .rating>input:not(:checked)~label:hover,
        .rating>input:not(:checked)~label:hover~label {
            background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' width='126.729' height='126.73'%3e%3cpath fill='%23d8b11e' d='M121.215 44.212l-34.899-3.3c-2.2-.2-4.101-1.6-5-3.7l-12.5-30.3c-2-5-9.101-5-11.101 0l-12.4 30.3c-.8 2.1-2.8 3.5-5 3.7l-34.9 3.3c-5.2.5-7.3 7-3.4 10.5l26.3 23.1c1.7 1.5 2.4 3.7 1.9 5.9l-7.9 32.399c-1.2 5.101 4.3 9.3 8.9 6.601l29.1-17.101c1.9-1.1 4.2-1.1 6.1 0l29.101 17.101c4.6 2.699 10.1-1.4 8.899-6.601l-7.8-32.399c-.5-2.2.2-4.4 1.9-5.9l26.3-23.1c3.8-3.5 1.6-10-3.6-10.5z'/%3e%3c/svg%3e");
        }

        .emoji-wrapper {
            width: 100%;
            text-align: center;
            height: 100px;
            overflow: hidden;
            position: absolute;
            top: 0;
            left: 0;
        }

        .emoji-wrapper:before,
        .emoji-wrapper:after {
            content: "";
            height: 15px;
            width: 100%;
            position: absolute;
            left: 0;
            z-index: 1;
        }

        .emoji-wrapper:before {
            top: 0;
            background: linear-gradient(to bottom, rgba(255, 255, 255, 1) 0%, rgba(255, 255, 255, 1) 35%, rgba(255, 255, 255, 0) 100%);
        }

        .emoji-wrapper:after {
            bottom: 0;
            background: linear-gradient(to top, rgba(255, 255, 255, 1) 0%, rgba(255, 255, 255, 1) 35%, rgba(255, 255, 255, 0) 100%);
        }

        .emoji {
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: .3s;
        }

        .emoji>svg {
            margin: 15px 0;
            width: 70px;
            height: 70px;
            flex-shrink: 0;
        }

        #rating-1:checked~.emoji-wrapper>.emoji {
            transform: translateY(-100px);
        }

        #rating-2:checked~.emoji-wrapper>.emoji {
            transform: translateY(-200px);
        }

        #rating-3:checked~.emoji-wrapper>.emoji {
            transform: translateY(-300px);
        }

        #rating-4:checked~.emoji-wrapper>.emoji {
            transform: translateY(-400px);
        }

        #rating-5:checked~.emoji-wrapper>.emoji {
            transform: translateY(-500px);
        }

        .feedback {
            max-width: 360px;
            background-color: #fff;
            width: 100%;
            padding: 30px;
            border-radius: 8px;
            display: flex;
            flex-direction: column;
            flex-wrap: wrap;
            align-items: center;
            box-shadow: 0 4px 30px rgba(0, 0, 0, .05);
        }
        #chartdiv {
            width: 100%;
            height: 500px;
        }
        #piechartDiv {
            width: 100%;
            height: 500px;
        }
    </style>
</head>

<body>

    <nav class="sb-topnav navbar navbar-expand navbar-dark bg-dark">
        <!-- Navbar Brand-->
        <a class="navbar-brand ps-3" href="../HR/"><img
                src="https://www.estarta.com/wp-content/uploads/2023/04/Estarta-Logo-Website.png" class="logo center"
                style="    height: 60px;
    width: 200px;
    margin-left: auto;
    margin-right: auto;
    display: block;" alt=""></a> <!-- Sidebar Toggle-->
        <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle" href="#!"><i
                class="fas fa-bars"></i></button>
        <!-- Navbar Search-->

        <!-- Navbar-->
        <ul class="navbar-nav ms-auto me-3 me-lg-4">
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown"
                    aria-expanded="false"><i class="fas fa-user fa-fw"></i></a>
                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                    <li><a class="dropdown-item" href="../Logout/logout.php">Logout</a></li>
                </ul>
            </li>
        </ul>

        <a href="../HR/showUsersMessages.php"><button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0"
                id="sidebarToggle" href="#!"><i class="fas fa-message"></i></button></a>
        <div style="height:20px; width:20px; background-color:red;text-align: center;
    color: #fff;
    font-weight: bold;border-radius: 100%;"><span id="numberOfMessages">0</span></div>
    </nav>
    <div id="layoutSidenav">
        <div id="layoutSidenav_nav">
            <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
                <div class="sb-sidenav-menu">
                    <div class="nav">
                    <?php
                        if($_SESSION['role'] == 'HR'){
                        ?>    
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../HR/">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Dashboard
                        </a>

                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../HR/InActiveUsers.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Pending approval
                        </a>

                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../HR/NotifyUsers.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Notify Employees
                        </a>
                        <!-- <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../HR/viewTimeSheet.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Employee Timesheet
                        </a> -->
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../HR/externalMessages.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            External Messages
                        </a>
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../HR/pendingSigntures.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Pending Signtures
                        </a>

                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../Recruiter/">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Jobs
                        </a>

                        
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../Recruiter/calendar.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Calendar
                        </a>
                        
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../HR/attendance.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Attendance
                        </a>
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../HR/leaves.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Leaves
                        </a>
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../HR/OrganizationChart.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Organizational Chart
                        </a>
                        <?php
                        }else{
                            ?>
                            <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../Home/">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Dashboard
                        </a>

                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../Home/Profile.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Profile
                        </a>
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../Home/ContactHR.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Contact HR
                        </a>
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../Home/ContactEmployee.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Contact Employee
                        </a>
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../Home/documents.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Intial Documents
                        </a>
                        <div class="sb-sidenav-menu-heading"></div>
                        <a class="nav-link" href="../HR/viewObjectives.php?userId=<?php echo $_SESSION['id'] ?>">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Objectives
                        </a>
                            <?php
                        }
                        ?>
                        <!--../HR/showUsersMessages.php-->
                    </div>

                </div>

            </nav>
        </div>
        <div id="layoutSidenav_content">
            <main>
                <div class="container-fluid px-4">
                    <h1 class="mt-4">Objectives </h1>
                    <ol class="breadcrumb mb-4">
                        <li class="breadcrumb-item active">Objectives </li>
                    </ol>

                    <div class="card mb-4">
                        <div class="card-header">
                            <i class="fas fa-table me-1"></i>
                            <span style = 'font-weight:bold'>View Objectives </span>
                        </div>

                        <div class="card text-center" style = "margin:20px">
                            
                            <div class="card-body">
                                
                                <div class = "row">

                                    <div class="col-md-4">
                                        <label for="exampleFormControlSelect2">Month</label>
                                        <select class = 'form-control' id="month">
                                            <option value=""></option>
                                            <option value="1">Jan</option>
                                            <option value="2">Feb</option>
                                            <option value="3">Mar</option>
                                            <option value="4">Apr</option>
                                            <option value="5">May</option>
                                            <option value="6">Jun</option>
                                            <option value="7">Jul</option>
                                            <option value="8">Aug</option>
                                            <option value="9">Sep</option>
                                            <option value="10">Oct</option>
                                            <option value="11">Nov</option>
                                            <option value="12">Dec</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="exampleFormControlSelect2">Year</label>
                                        <select class = 'form-control' id="year">
                                                <option value=""></option>
                                                <option value="2025">2025</option>
                                                <option value="2026">2026</option>
                                                <option value="2027">2027</option>
                                            </select>
                                    </div>
                                    <div class="col-md-4">
                                        <!-- <label for="exampleFormControlSelect2" style="color:white">search</label> -->
                                        <button style="margin-top:30px" id="search-btn" type="button" class = "btn btn-primary">Search</button>
                                    </div>
                                </div>
                            </div>
                            
                        </div>

                    
                        <div class="card-body">
                            <div class="card" style="margin:20px">
                                <div style="display: flex;">
                                    <div id="chartdiv" style="flex: 1; padding: 20px;">
                                    </div>

                                    <div id="piechartDiv" style="flex: 1; padding: 20px;">
                                        
                                    </div>
                                </div>
                            </div>
                            
                            
                            <form id="myForm">
                                <input type="hidden" id="userID" value="<?php echo $_GET['userId'] ?>">

                                <?php
                                $totalRated = 0;
                                $totalValue = 0;

                                while($row = mysqli_fetch_assoc($result)){
                                    if($row['rate']){
                                        $totalValue+=$row['rate'];
                                        $totalRated++;
                                    }
                                ?>
                                <div class="card text-center" style = "margin:20px">
                                    <div class="card-header">
                                        Objective
                                    </div>
                                    <div class="card-body">
                                        <p class="card-text"><?php echo $row['objective'] ?>.</p>
                                        <?php 
                                        if($row['comments']){
                                            ?>
                                        <p class="card-text">Comments: <?php echo $row['comments'] ?>.</p>

                                            <?php
                                        }
                                        ?>
                                         <?php 
                                        if($row['file']){
                                            ?>
                                        <p class="card-text">file: <a href="https://lifepulsecrm.com/Nadeen/HR/objectivesFiles/<?php echo $row['file'] ?>" target="_blank" rel="noopener noreferrer"> <?php echo $row['file'] ?></a></p>

                                            <?php
                                        }
                                        ?>

                                         <?php
                                            if($row['rate_date']){
                                                ?>
                                                    <div class="progress">
                                                        <div class="progress-bar" role="progressbar" style="width: <?php echo $row['rate'] ?>%" aria-valuenow="<?php echo $row['rate'] ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                <?php
                                            }
                                                if($_SESSION['role'] == 'HR'){
                                                    

                                                ?>

                                                <button type="button" style = "margin-top:10px" class="btn btn-primary rate_btn" data-id = "<?php echo $row['id'] ?>" data-toggle="modal" data-target="#exampleModal">
                                                    Rate
                                                </button>

                                                <?php
                                                }else{
                                                      ?>
                                                    <button type="button"  class="btn btn-primary" data-id = "<?php echo $row['id'] ?>" >
                                                        Not rated yet
                                                    </button>
                                                      <?php
                                                }
                                            
                                        ?>
                                        
                                    </div>
                                    <div class="card-footer text-muted">
                                        <?php
                                            if($row['rate_date']){
                                                echo $row['rate_date'];
                                            }else{
                                                echo "N/A";
                                            }
                                        ?>
                                    </div>
                                </div>
                                <?php
                                }

                                $finalVal = $totalValue / $totalRated;
                                ?>
                                <input type="hidden" id="finalVal" value = "<?php  echo $finalVal?>">
                            </form>
                        </div>
                    </div>
                </div>
            </main>
            <footer class="py-4 bg-light mt-auto">
                <div class="container-fluid px-4">
                    <div class="d-flex align-items-center justify-content-between small">
                    </div>
                </div>
            </footer>
        </div>
    </div>
    
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Rate</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <input class = 'form-control' type="hidden" name="objectiveID" id="objectiveID">
             <div class="form-group">
                <label for="exampleInputEmail1">Rate</label>
                <input class = 'form-control' type="number" name="objectiveVale" id="objectiveVale" min = '0' max = '100'>
                <small id="emailHelp" class="form-text text-muted">Max value is 100.</small>
            </div>
            
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="button" id="rate_button" class="btn btn-primary">Save changes</button>
        </div>
        </div>
    </div>
    </div>

</body>

<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
  
<script src="js/scripts.js"></script>

<script src="https://cdn.jsdelivr.net/npm/simple-datatables@latest" crossorigin="anonymous"></script>
<script src="js/datatables-simple-demo.js"></script>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"
    integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj"
    crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js"
    integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx"
    crossorigin="anonymous"></script>
        <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>



  <script>
        const URI = "../HR/hrController.php";
        $(document).ready(function () {

            getCharData()
            
            $("#search-btn").click(function(){
                getCharData()
            })
            $(".rate_btn").click(function(){
                console.log($(this).attr('data-id'))
                $("#objectiveID").val($(this).attr('data-id'))
            })

            $("#rate_button").click(function(){
              
                var objectiveID = $("#objectiveID").val();
                var objectiveVale = $("#objectiveVale").val();
                $.ajax({
                    type: "POST",
                    url: URI+'?action=rateObjective',
                    data: {objectiveID,objectiveVale},
                    dataType: 'JSON',
                    success: function (response) {
                        if(response.data == 'done'){
                            Swal.fire({
                                icon: 'success',
                                title: 'Great',
                                text: 'Objectives rated successfully',
                                confirmButtonText: 'Ok',
                                confirmButtonColor: 'red'
                            }).then((result) => {
                            if (result.isConfirmed) {
                                location.reload()
                            } 
                            });
                            
                        }else{
                            Swal.fire({
                                icon: 'error',
                                title: 'Oops...',
                                text: 'an error occurred please try again!',
                                confirmButtonText: 'Ok',
                                confirmButtonColor: 'red',
                            })  
                        }
                    }
                });

            })
        })
        
    </script>
    <script src="https://cdn.amcharts.com/lib/4/core.js"></script>
<script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
<script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
<script>
function drawPie(chartData){
  am4core.ready(function() {

    am4core.useTheme(am4themes_animated);

    var chart = am4core.create("piechartDiv", am4charts.PieChart);

    chart.data = chartData;

    var pieSeries = chart.series.push(new am4charts.PieSeries());
    pieSeries.dataFields.value = "score";
    pieSeries.dataFields.category = "month";

    // Remove leader lines and/or labels
    pieSeries.ticks.template.disabled = true;   // removes the weird lines
    pieSeries.labels.template.disabled = true;  // optional (if you don't want labels)

    pieSeries.hiddenState.properties.opacity = 1;
    pieSeries.hiddenState.properties.endAngle = -90;
    pieSeries.hiddenState.properties.startAngle = -90;

});

}
function drawChart(chartData) {

  am4core.ready(function () {

    // Themes begin
    am4core.useTheme(am4themes_animated);
    // Themes end

    // Create chart instance
    var chart = am4core.create("chartdiv", am4charts.XYChart);

    // Enable chart cursor
    chart.cursor = new am4charts.XYCursor();
    chart.cursor.lineX.disabled = true;
    chart.cursor.lineY.disabled = true;

    // Enable scrollbar
    chart.scrollbarX = new am4core.Scrollbar();
    chart.data = chartData;

    // Add data

    // Create axes
    var dateAxis = chart.xAxes.push(new am4charts.DateAxis());
    dateAxis.renderer.grid.template.location = 0.5;
    dateAxis.dateFormatter.inputDateFormat = "yyyy-MM-dd";
    dateAxis.renderer.minGridDistance = 40;
    dateAxis.tooltipDateFormat = "MMM dd, yyyy";
    dateAxis.dateFormats.setKey("day", "dd");

    var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());

    // Create series
    var series = chart.series.push(new am4charts.LineSeries());
    series.tooltipText = "{date}\n[bold font-size: 17px]value: {valueY}[/]";
    series.dataFields.valueY = "value";
    series.dataFields.dateX = "date";
    series.strokeDasharray = 3;
    series.strokeWidth = 2
    series.strokeOpacity = 0.3;
    series.strokeDasharray = "3,3"

    var bullet = series.bullets.push(new am4charts.CircleBullet());
    bullet.strokeWidth = 2;
    bullet.stroke = am4core.color("#fff");
    bullet.setStateOnChildren = true;
    bullet.propertyFields.fillOpacity = "opacity";
    bullet.propertyFields.strokeOpacity = "opacity";

    var hoverState = bullet.states.create("hover");
    hoverState.properties.scale = 1.7;

    function createTrendLine(data) {
      var trend = chart.series.push(new am4charts.LineSeries());
      trend.dataFields.valueY = "value";
      trend.dataFields.dateX = "date";
      trend.strokeWidth = 2
      trend.stroke = trend.fill = am4core.color("#c00");
      trend.data = data;

      var bullet = trend.bullets.push(new am4charts.CircleBullet());
      bullet.tooltipText = "{date}\n[bold font-size: 17px]value: {valueY}[/]";
      bullet.strokeWidth = 2;
      bullet.stroke = am4core.color("#fff")
      bullet.circle.fill = trend.stroke;

      var hoverState = bullet.states.create("hover");
      hoverState.properties.scale = 1.7;

      return trend;
    };
  }); // end am4core.ready()

}
function getCharData(){
    var userID = $("#userID").val()
    var month = $("#month").val()
    var year = $("#year").val()

      $.ajax({
      type: "POST",
      url: URI + '?action=getChartData',
      data: {
        userID,
        year,
        month
      },
      dataType:"JSON",
      success: function (response) {
        drawChart(response.data)
        drawPie(response.pieData)
      }
  });
}
</script>


</html>