<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estarta</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Turret+Road:wght@200;300;400;500;700;800&display=swap');

:root {
    --header-height: 3.5rem;

    --dark-color: #191D28;
    --dark-color-alt: #1E222D;
    --main-color: #F0082F;
    --main-color-alt: #FF164C;
    --title-color: #FFFFFF;
    --text-color: #E9E9E9;

    --body-font: 'Poppins', sans-serif;
    --logo-font: 'Turret Road', sans-serif;
    --big-font-size: 3.5rem;
    --h1-font-size: 2.25rem;
    --h2-font-size: 1.5rem;
    --h3-font-size: 1.25rem;
    --normal-font-size: 1rem;
    --small-font-size: .875rem;
    --smaller-font-size: .813rem;

    --font-medium: 500;
    --font-semi-bold: 600;

    --mb0-5: .5rem;
    --mb0-75: .75rem;
    --mb1: 1rem;
    --mb1-5: 1.5rem;
    --mb2: 2rem;
    --mb2-5: 2.5rem;

    --z-fixed: 100;
}

@media screen and (max-width: 992px) {
    :root {
        --big-font-size: 2.25rem;
        --h1-font-size: 1.5rem;
        --h2-font-size: 1.25rem;
        --h3-font-size: 1rem;
        --normal-font-size: .938rem;
        --small-font-size: .813rem;
        --smaller-font-size: .75rem;
    }
}

* { margin: 0; padding: 0; box-sizing: border-box; scroll-behavior: smooth; }
body, button, textarea { font-family: var(--body-font); font-size: var(--normal-font-size); }
    body { background-color: var(--dark-color); color: var(--text-color); }
    button { cursor: pointer; border: none; outline: none; }
h1, h2, h3 { color: var(--title-color); font-weight: var(--font-semi-bold); }
ul { list-style-type: none; }
a { text-decoration: none; }
img { max-width: 100%; height: auto; }
.container { max-width: 1140px; margin-left: auto; margin-right: auto; overflow: hidden; }
.grid { display: grid; }
.home-container, .feature-container, .accordion-container, .contact-container { grid-template-columns: repeat(2, 1fr); column-gap: 2rem; }
.button { display: inline-block; background-color: var(--main-color); color: var(--title-color); padding: 1rem 1.75rem; border-radius: .5rem; font-weight: var(--font-medium); transition: .3s; }
    .button:hover { background-color: var(--main-color-alt); }
.button-icon { transition: .3s; }
    .button:hover .button-icon { transform: translateX(.25rem); }
.button-flex { display: inline-flex; align-items: center; column-gap: .5rem; }
.section { padding: 8rem 0 1rem; }
.section-title { font-size: var(--h1-font-size); margin-bottom: 4rem; font-weight: var(--font-semi-bold); text-align: center; }
.image { position: relative; display: flex; justify-content: center; align-items: center; }
.banner-app-mock { position: relative; width: 272px; }
    .banner-app-mock .main-img { margin-top: 20px; margin-left: 15px; width: 240px; height: 520px; }
    .banner-app-mock .mockup { width: 277px; height: 552px; position: absolute; right: 0; top: 0; z-index: 5; }
.mobile-graphic { width: 100%; position: absolute; left: 0; top: 0; z-index: -2; }

/* Header */

.header { width: 100%; background-color: var(--dark-color); position: fixed; top: 0; left: 0; z-index: var(--z-fixed); }
.nav { height: calc(var(--header-height) + 1.5rem); display: flex; justify-content: space-between; align-items: center; column-gap: 3rem; }
.nav-logo { display: flex; align-items: center; font-weight: var(--font-medium); column-gap: .5rem; }
.nav-logo-img { width: 1.25rem; }
.nav-list { display: flex; column-gap: 3rem; }
.nav-link, .nav-logo, .nav-toggle { color: var(--title-color); }
    .nav-toggle { font-size: 1.2rem; cursor: pointer; }
    .nav-link { font-weight: var(--font-medium); transition: .3s; }
        .nav-link:hover { color: var(--main-color); }
.nav-close { font-size: 1.2rem; position: absolute; top: 1rem; right: 1.25rem; cursor: pointer; }
    .nav-toggle, .nav-close { display: none; }
.active-link { position: relative; color: var(--main-color); }
    .active-link::before { content: ''; position: absolute; bottom: -0.5rem; left: 0; width: 50%; height: 2px; background-color: var(--main-color); }
.scroll-header { box-shadow: 0 1px 4px rgba(165, 125, 125, .7); }

/* Home */

.home { padding: 12rem 0 5rem;}
.home-data { align-self: center; }
.home-title { font-size: var(--big-font-size); line-height: 120%; margin-bottom: var(--mb1); }
    .home-title span { color: var(--main-color); }
.home-description { margin-bottom: var(--mb2-5); line-height: 2.2rem; }

/* Feature */

.feature-inside { align-self: center; }
    .feature-inside ul li { width: 100%; padding-bottom: var(--mb2-5); padding-left: 70px; position: relative; }
        .feature-inside ul li img { position: absolute; left: 0; top: 0; }
        .feature-inside ul li h3 { font-size: var(--h3-font-size); padding-bottom: var(--mb1); }
            .feature-inside ul li:hover h3 { color: var(--main-color); }
        .feature-inside ul li p { font-weight: var(--font-medium); font-size: var(--smaller-font-size); }
            .feature-inside ul li:hover p { color: var(--main-color-alt); }
.btn-group { display: flex; gap: 1.25rem; }
    .btn-group .button { position: relative; padding-left: 45px; padding-right: 18px; text-align: center; }
        .btn-group .button i { position: absolute; left: 8px; top: 24px; }

/* Pricing */

.pricing-container { grid-template-columns: repeat(3, 1fr); gap: 2rem; }
.pricing-plan { border: 1px solid var(--main-color); border-radius: 10px; width: 100%; overflow: hidden; }
    .pricing-plan .pricing-header { padding: 20px 30px; position: relative; }
        .pricing-plan .pricing-header h3 { font-size: var(--h3-font-size); text-transform: capitalize; }
.best-value { position: absolute; right: -35%; top: 50%; width: 100%; background-color: var(--main-color); text-transform: capitalize; transform: rotate(50deg); font-size: var(--h3-font-size); text-align: center; padding: 10px 0; }
    .pricing-plan .pricing-price { padding: 40px 30px; display: flex; line-height: 0.7; }
        .pricing-plan .pricing-price .currency { font-size: var(--small-font-size); font-weight: var(--font-medium); margin-right: 5px; align-self: flex-start; }
        .pricing-plan .pricing-price .price { font-size: var(--big-font-size); font-weight: var(--font-semi-bold); color: var(--main-color); }
        .pricing-plan .pricing-price .period { font-size: var(--smaller-font-size); font-weight: var(--font-medium); margin-right: 5px; align-self: flex-end; text-transform: uppercase; }
    .pricing-plan .pricing-body { padding: 0 30px; }
        .pricing-plan .pricing-body ul li { font-size: var(--small-font-size); font-weight: 300; padding: 10px 0 10px 30px; line-height: 26px; position: relative; }
            .pricing-plan .pricing-body ul li i { color: var(--main-color); position: absolute; left: 0; top: 14px; }
    .pricing-plan .pricing-footer { padding: 40px; text-align: center; }

/* Testimonial */

.testimonial-item { padding: 2rem 0; background-color: var(--dark-color-alt); width: 340px; border-radius: 1rem; text-align: center; }
    .testimonial-item .img-box { width: 120px; height: 120px; display: inline-block; margin-bottom: var(--mb1); border: 4px solid var(--main-color); border-radius: 50%; position: relative; }
        .testimonial-item .img-box img { border-radius: 50%; width: 100%; }
    .testimonial-item h3 { font-size: var(--h3-font-size); font-weight: var(--font-semi-bold); text-transform: capitalize; transition: .3s; }
    .testimonial-item span { display: block; margin-bottom: var(--mb0-75); font-weight: var(--font-medium); font-size: var(--small-font-size); transition: .3s; }
    .testimonial-item ul li { display: inline-block; padding-left: 10px; }
        .testimonial-item ul li a { color: var(--title-color); font-size: var(--smaller-font-size); transition: .3s; }
            .testimonial-item:hover ul li a, .testimonial-item:hover h3, .testimonial-item:hover span { color: var(--main-color); }

/* Accordion */

.accordion-content { align-self: center; }
.accordion-item { background-color: var(--dark-color-alt); transition: .3s; }
.accordion-item:not(:last-child) { margin-bottom: var(--mb1); }
.accordion-header { padding: 0.75rem 1.25rem; transition: .3s; cursor: pointer; position: relative; background-color: rgba(0, 0, 0, .03); border-bottom: 1px solid rgba(0, 0, 0, .125); }
    .accordion-header::before {
        content: '\f067';
        font-family: 'Font Awesome 5 Free';
        font-weight: var(--font-semi-bold);
        position: absolute;
        height: 30px;
        width: 30px;
        right: 10px;
        top: 50%;
        color: var(--main-color);
        transform: translateY(-50%);
        text-align: center;
        line-height: 30px;
    }
        .accordion-item.collapsed .accordion-header::before { content: '\f068';}
.accordion-body { height: 0; overflow: hidden; display: flex; align-items: center; transition: .3s; }
    .accordion-item.collapsed .accordion-body { height: 120px; overflow: visible; }
    .accordion-body p { font-size: var(--small-font-size); padding: 1rem 1.25rem; transition: .3s; }

/* Contact */

.contact .section-title { text-align: left; }
.contact-data { display: grid; row-gap: 2rem; }
.contact-subtitle { font-size: var(--normal-font-size); font-weight: var(--font-medium); color: var(--text-color); margin-bottom: var(--mb0-5); }
.contact-description { display: inline-flex; align-items: center; column-gap: .5rem; color: var(--title-color); font-weight: var(--font-medium); }
.contact-icon { font-size: 1.25rem; }
.contact-inputs { display: grid; row-gap: 2rem; margin-bottom: var(--mb2-5); }
.contact-content { position: relative; height: 3rem; border-bottom: 2px solid var(--text-color); }
    .contact-content span { position: absolute; bottom: -2px; left: 0; content: ''; height: 2px; width: 0; background-color: var(--main-color); transition: .5s; }
.contact-input { position: absolute; top: 0; left: 0; width: 100%; height: 100%; padding: 1rem 1rem 1rem 0; background: none; color: var(--text-color); outline: none; border: none; z-index: 1; }
    .contact-input:focus ~ span { width: 100%; }
.contact-label { position: absolute; top: 0.75rem; width: 100%; font-size: var(--small-font-size); color: var(--text-color); transition: .3s; }
    .contact-input + .contact-label { top: -0.75rem; left: 0; font-size: var(--small-font-size); z-index: 10; color: var(--main-color); }
.contact-area { height: 7rem; }
    .contact-area textarea { resize: none; }

/* Footer */

.footer-container { grid-template-columns: 1fr .5fr .5fr .5fr; column-gap: 3rem; }
.footer-logo { display: flex; align-items: center; column-gap: .5rem; margin-bottom: var(--mb2); font-weight: var(--font-medium); color: var(--text-color); }
.footer-logo-img { width: 20px; }
.footer-title { font-size: var(--h3-font-size); margin-bottom: var(--mb1-5); }
.footer-subscribe { background-color: var(--dark-color-alt); padding: 0.75rem; display: flex; justify-content: space-between; border-radius: .5rem; width: 400px; }
.footer-input { width: 70%; padding: 0 0.5rem; background: none; border: none; outline: none; color: var(--text-color); }
.footer-button { padding: 1rem; }
.footer-data { display: grid; row-gap: .75rem; }
.footer-information-link a { color: var(--text-color); font-size: var(--small-font-size); transition: .3s; }
    .footer-information-link:hover a { color: var(--main-color); }
.footer-information { font-size: var(--small-font-size); }
.footer-social { display: inline-flex; column-gap: .75rem; }
.footer-social-link { font-size: 1rem; color: var(--text-color); transition: .3s; }
    .footer-social-link:hover { color: var(--main-color); }
.footer-copy { margin: 7rem 0 2rem; text-align: center; font-size: var(--smaller-font-size); color: var(--text-color); }
    .footer-copy span { font-family: var(--logo-font); }

/* Media Queries */

@media (max-width: 1200px) {
    .container { margin-left: var(--mb1-5); margin-right: var(--mb1-5); }
}

@media (max-width: 992px) {
    .home-description { line-height: 1.8rem; }
    .pricing-container, .footer-container { grid-template-columns: repeat(2, 1fr); }
}

@media (max-width: 767px) {
    body { margin: var(--header-height) 0 0 0; }
    .nav { height: var(--header-height); }
    .nav-list { flex-direction: column; row-gap: 1.5rem; }
    .nav-menu { 
        position: fixed; 
        background-color: var(--dark-color);
        width: 88%; 
        height: 100%; 
        top: 0; 
        right: -100%; 
        padding: 4rem 0 0 3rem; 
        box-shadow: -2px 0 4px var(--dark-color); 
        border-radius: 1rem 0 0 1rem; 
        z-index: var(--z-fixed); 
        transition: .3s; 
    }
    .nav-close, .nav-toggle { display: inline-flex; }
    .show-menu { right: 0; }
    .home { padding: 5.5rem 0 1rem; }
    .section { padding: 5.5rem 0 1rem; }
    .home-container, .feature-container, .pricing-container, .accordion-container, .contact-container, .footer-container { grid-template-columns: 1fr; row-gap: 2rem; }
    .home-data { display: flex; align-items: center; justify-content: center; flex-direction: column; }
    .feature-img { display: none; }
    .accordion-container { row-gap: 4rem; }
    .contact-container { row-gap: 3rem; }
    /*.image { justify-content: start; }*/
    /*.mobile-graphic { left: -5%; }*/
    .btn-group { justify-content: center; align-items: center; flex-direction: column; }
    .testimonial-item { width: 252px; }
    .contact-box { display: flex; flex-direction: column; justify-content: center; align-items: center; }
        .contact-box .section-title { text-align: center; }
        .contact-box .contact-information { text-align: center; }
    .footer-content { text-align: center;}
        .footer-content .footer-logo { justify-content: center; }
        .footer-content .footer-social { justify-content: center; align-items: center; }
        .footer-content .footer-subscribe { margin-inline: auto; width: 320px; }
}

@media (max-width: 392px) {
    .container { margin-left: var(--mb1); margin-right: var(--mb1); }
    .home-title { font-size: var(--h1-font-size); }
    .home-description { line-height: 1.4rem; }
    .feature-inside ul li { padding-bottom: var(--mb2); padding-left: 60px; }
        .feature-inside ul li h3 { padding-bottom: var(--mb0-75); }
        /*.feature-inside ul li img { display: none; }*/
    .footer-content .footer-subscribe { width: initial; }
}
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>
    <link rel="shortcut icon" href="https://www.estarta.com/wp-content/uploads/2023/04/Estarta-Logo-Website.png">
</head>
<body>
    <header class="header" id="header">
        <nav class="nav container">
            <a href="#" class="nav-logo"><img style="width: 200px;" src="https://www.estarta.com/wp-content/uploads/2023/04/Estarta-Logo-Website.png" alt="logo image" class="nav-logo-img"></a>

            <div class="nav-menu" id="nav-menu">
                <ul class="nav-list">
                    <li class="nav-list"><a href="#home" class="nav-link active-link">Home</a></li>
                    <li class="nav-list"><a href="#features" class="nav-link">Features</a></li>
                    <li class="nav-list"><a href="#pricing" class="nav-link">Pricing</a></li>
                    <li class="nav-list"><a href="#team" class="nav-link">Team</a></li>
                    <li class="nav-list"><a href="#faq" class="nav-link">FAQ</a></li>
                    <li class="nav-list"><a href="#contact" class="nav-link">Contact</a></li>
                </ul>         
                <div class="nav-close" id="nav-close">
                    <i class="fas fa-times"></i>
                </div>  
            </div>
            <div class="nav-toggle" id="nav-toggle">
                <i class="fas fa-th-large"></i>
            </div>
        </nav>
    </header>

    <section class="home" id="home">
        <div class="home-container container grid">
            <div class="home-data">
                <h1 class="home-title"><span>Estarta</span>Solutions</h1>
            </div>

            <div class="home-img image">
                <div class="banner-app-mock">
                    <img src="https://i.postimg.cc/fWFWGWrF/mobile-mock.png" class="mockup" alt="mobile image">
                    <img src="https://i.postimg.cc/52LWbPyt/work3.jpg" class="main-img" alt="home image">
                </div>
                <div class="mobile-graphic">
                    <img src="https://i.postimg.cc/50DBQdst/mobile-graphic.png" alt="mobile graphic">
                </div>
            </div>
        </div>
    </section>

    <section class="features section" id="features">
        <h2 class="section-title">Career Skills Features</h2>
        <div class="feature-container container grid">
            <div class="feature-img image">
                <div class="banner-app-mock">
                    <img src="https://i.postimg.cc/fWFWGWrF/mobile-mock.png" class="mockup" alt="mobile image">
                    <img src="https://i.postimg.cc/52LWbPyt/work3.jpg" class="main-img" alt="home image">
                </div>
                <div class="mobile-graphic">
                    <img src="https://i.postimg.cc/50DBQdst/mobile-graphic.png" alt="mobile graphic">
                </div>
            </div>

            <div class="feature-inside">
                <ul>
                    <li>
                        <img src="https://i.postimg.cc/bJfYZmQh/feature1.png" alt="feature image">
                        <h3>Practice on our mobile app</h3>
                        <p>Our mobile app puts the power of practice at your fingertips. Whether you're on the bus, waiting in line, or simply taking a break, you can level up your skills with engaging exercises and interactive lessons</p>
                    </li>

                    <li>
                        <img src="https://i.postimg.cc/9X1SSHGs/feature2.png" alt="feature image">
                        <h3>Best Skill Paths</h3>
                        <p>In today's rapidly evolving digital landscape, choosing the right IT skill path can set you on a trajectory for success. Whether you're a seasoned professional or just starting your journey, exploring the best IT skill paths is essential</p>
                    </li>

                    <li>
                        <img src="https://i.postimg.cc/02TCXVHL/feature3.png" alt="feature image">
                        <h3>Choose your Career Path</h3>
                        <p>A career path prepares you for a job in tech. Choose from a variety of careers — including Data Scientist, Front-End Engineer, Back-End Engineer, Full-Stack Engineer, or iOS Developer. We'll guide you through everything you need to know to land a job</p>
                    </li>
                </ul>

                <div class="btn-group">
                    <a href="#" class="button"><i class="fab fa-apple fa-2x"></i>Available in <br>Apple</a>
                    <a href="#" class="button"><i class="fab fa-google-play fa-2x"></i>Available in <br>Android</a>
                </div>
            </div>
        </div>
    </section>

    <section class="pricing section" id="pricing">
        <h2 class="section-title">Our Pricing Plans</h2>
        <div class="pricing-container container grid">
            <div class="pricing-plan">
                <div class="pricing-header">
                    <h3>Basic</h3>
                </div>
            
                <div class="pricing-price">
                    <span class="currency"></span>
                    <span class="price">Free</span>
                    <span class="period"></span>
                </div>

                <div class="pricing-body">
                    <ul>
                        <li><i class="fa fa-check"></i>Access to Free Courses</li>
                        <li><i class="fa fa-check"></i>Limited Number of Quizzes</li>
                        <li><i class="fa fa-check"></i>Community Support</li>
                        <li><i class="fa fa-check"></i>Limited Number of Real World Projects</li>
                        <li><i class="fa fa-check"></i>Limited Practice on Mobile App</li>
                    </ul>
                </div>

                <div class="pricing-footer">
                    <a href="#" class="button button-flex">Explore <i class="ri-arrow-right-down-line button-icon"></i></a>
                </div>
            </div>

            <div class="pricing-plan">
                <div class="pricing-header">
                    <h3>Premium</h3>
                    <h3 class="best-value">best value</h3>
                </div>
            
                <div class="pricing-price">
                    <span class="currency">$</span>
                    <span class="price">10</span>
                    <span class="period">/monthly</span>
                </div>

                <div class="pricing-body">
                    <ul>
                        <li><i class="fa fa-check"></i>Access to Free Courses</li>
                        <li><i class="fa fa-check"></i>Unlimited Number of Quizzes</li>
                        <li><i class="fa fa-check"></i>Community Support</li>
                        <li><i class="fa fa-check"></i>Unlmited Number of Real World Projects</li>
                        <li><i class="fa fa-check"></i>Unlimited Practice on Mobile App</li>
                        <li><i class="fa fa-check"></i>Access to Skill Paths</li>
                    </ul>
                </div>
                
                <div class="pricing-footer">
                    <a href="#" class="button button-flex">Explore <i class="ri-arrow-right-down-line button-icon"></i></a>
                </div>
            </div>

            <div class="pricing-plan">
                <div class="pricing-header">
                    <h3>Professional</h3>
                </div>
            
                <div class="pricing-price">
                    <span class="currency">$</span>
                    <span class="price">15</span>
                    <span class="period">/monthly</span>
                </div>

                <div class="pricing-body">
                    <ul>
                        <li><i class="fa fa-check"></i>Access to Free Courses</li>
                        <li><i class="fa fa-check"></i>Unlimited Number of Quizzes</li>
                        <li><i class="fa fa-check"></i>Community Support</li>
                        <li><i class="fa fa-check"></i>Unlmited Number of Real World Projects</li>
                        <li><i class="fa fa-check"></i>Unlimited Practice on Mobile App</li>
                        <li><i class="fa fa-check"></i>Access to Skill Paths</li>
                        <li><i class="fa fa-check"></i>Access to Career Paths</li>
                        <li><i class="fa fa-check"></i>Access to Professional Certifications</li>
                    </ul>
                </div>
                
                <div class="pricing-footer">
                    <a href="#" class="button button-flex">Explore <i class="ri-arrow-right-down-line button-icon"></i></a>
                </div>
            </div>
        </div>
    </section>

    <section class="testimonials section" id="team">
        <h2 class="section-title">Meet the Team</h2>
        <div class="testimonials-container container">
            <div class="swiper testimonials-swiper">
                <div class="swiper-wrapper">
                    <div class="testimonial-item swiper-slide">
                        <div class="img-box"><img src="https://i.postimg.cc/Pf6GJVXG/team1.jpg" alt="team member"></div>
                        <h3>John Doe</h3>
                        <span>UI Designer</span>
                        <ul>
                            <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="#"><i class="ri-twitter-x-line"></i></a></li>
                            <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
                        </ul>
                    </div>

                    <div class="testimonial-item swiper-slide">
                        <div class="img-box"><img src="https://i.postimg.cc/TwCsyhXj/team2.jpg" alt="team member"></div>
                        <h3>Laura Moore</h3>
                        <span>Ux Designer</span>
                        <ul>
                            <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="#"><i class="ri-twitter-x-line"></i></a></li>
                            <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
                        </ul>
                    </div>

                    <div class="testimonial-item swiper-slide">
                        <div class="img-box"><img src="https://i.postimg.cc/YCNBrrjR/team3.jpg" alt="team member"></div>
                        <h3>Oliver Stone</h3>
                        <span>UI Designer</span>
                        <ul>
                            <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="#"><i class="ri-twitter-x-line"></i></a></li>
                            <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="accordion section" id="faq">
        <h2 class="section-title">Frequently Asked Questions</h2>
        <div class="accordion-container container grid">
            <div class="accordion-img image">
                <div class="banner-app-mock">
                    <img src="https://i.postimg.cc/fWFWGWrF/mobile-mock.png" class="mockup" alt="mobile image">
                    <img src="https://i.postimg.cc/52LWbPyt/work3.jpg" class="main-img" alt="home image">
                </div>
                <div class="mobile-graphic">
                    <img src="https://i.postimg.cc/50DBQdst/mobile-graphic.png" alt="mobile graphic">
                </div>
            </div>

            <div class="accordion-content">
                <div class="accordion-item">
                    <div class="accordion-header">
                        <h3>100% Responsive - Fits any device peefectly</h3>
                    </div>
                    <div class="accordion-body">
                        <p>Forget squinting at tiny text or struggling to navigate a website on your phone</p>
                    </div>
                </div>

                <div class="accordion-item collapsed">
                    <div class="accordion-header">
                        <h3>Join Skill Paths of your preference</h3>
                    </div>
                    <div class="accordion-body">
                        <p>Skill paths are structured curriculum roadmaps that show you exactly where to start and what to learn next</p>
                    </div>
                </div>

                <div class="accordion-item">
                    <div class="accordion-header">
                        <h3>Suitable for Children</h3>
                    </div>
                    <div class="accordion-body">
                        <p>Coding is just like learning a new language or studying math. Children who learn to code when they're young can set themselves up for a lifetime of opportunities for success</p>
                    </div>
                </div>

                <div class="accordion-item">
                    <div class="accordion-header">
                        <h3>Earn Professional Certifications</h3>
                    </div>
                    <div class="accordion-body">
                        <p>To earn a professional certification, you need to pass a series of exams. These exams assess proficiency in the concepts you're learning</p>
                    </div>
                </div>
            </div
        </div>
    </section>

    <section class="contact section container" id="contact">
        <div class="contact-container grid">
            <div class="contact-box">
                <h2 class="section-title">Reach out us today <br> via any of the given <br> information</h2>
                <div class="contact-data">
                    <div class="contact-information">
                        <h3 class="contact-subtitle">Call us for instant support</h3>
                        <span class="contact-description">
                            <i class="ri-phone-line contact-icon"></i>+1 (702) 487 3678
                        </span>
                    </div>

                    <div class="contact-information">
                        <h3 class="contact-subtitle">Write us an email</h3>
                        <span class="contact-description">
                            <i class="ri-mail-line contact-icon"></i>user@gmail.com
                        </span>
                    </div>
                </div>

            </div>
            <form action="" class="contact-form">
                <div class="contact-inputs">
                    <div class="contact-content">
                        <input type="email" placeholder="" class="contact-input">
                        <label for="" class="contact-label">Email</label>
                        <span></span>
                    </div>

                    <div class="contact-content">
                        <input type="text" placeholder="" class="contact-input">
                        <label for="" class="contact-label">Subject</label>
                        <span></span>
                    </div>

                    <div class="contact-content contact-area">
                        <textarea name="message" id="" cols="30" rows="10" class="contact-input"></textarea>
                        <label for="" class="contact-label">Message</label>
                        <span></span>
                    </div>
                </div>
                <button class="button button-flex">
                    Send Message
                    <i class="ri-arrow-right-up-line button-icon"></i>
                </button>
            </form>
        </div>
    </section>

    <footer class="footer section">
        <div class="footer-container container grid">
            <div class="footer-content">
                <a href="#" class="footer-logo"><img src="" alt=""><img src="https://i.postimg.cc/9M8zkG6w/logo.png" alt="logo image" class="footer-logo-img">Bingles.</a>
                <h3 class="footer-title">Subscribe to our newsletter <br> to stay update</h3>

                <div class="footer-subscribe">
                    <input type="email" placeholder="Enter your email" class="footer-input">
                    <button class="button button-flex footer-button">
                        Subscribe
                        <i class="ri-arrow-right-up-line button-icon"></i>
                    </button>
                </div>
            </div>
            <div class="footer-content">
                <h3 class="footer-title">Our Address</h3>
                <ul class="footer-data">
                    <li class="footer-information">United States of America</li>
                    <li class="footer-information">815 Porto Mio Way</li>
                    <li class="footer-information">Las Vegas, NV</li>
                </ul>
            </div>
            <div class="footer-content">
                <h3 class="footer-title">Contact Us</h3>
                <ul class="footer-data">
                    <li class="footer-information">+1 (702) 487 3678</li>
                    <div class="footer-social">
                        <a href="#" class="footer-social-link"><i class="ri-facebook-fill"></i></a>
                        <a href="#" class="footer-social-link"><i class="ri-instagram-line"></i></a>
                        <a href="#" class="footer-social-link"><i class="ri-twitter-x-line"></i></a>
                    </div>
                </ul>
            </div>
            <div class="footer-content">
                <h3 class="footer-title">Our Services</h3>
                <ul class="footer-data">
                    <li class="footer-information-link"><a href="#">Pricing</a></li>
                    <li class="footer-information-link"><a href="#">Features</a></li>
                    <li class="footer-information-link"><a href="#">FAQ</a></li>
                </ul>
            </div>
        </div>
        <p class="footer-copy">&#169; <span>ULTRA CODE</span>. All rights reserved</p>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script>
        //Testimonial Swiper

var testimonialSwiper = new Swiper(".testimonials-swiper", {
    slidesPerView: "auto",
    centeredSlides: true,
    spaceBetween: 32,
    loop: true,
  });

//Accordion FAQ

let accordion = document.querySelector('.accordion-content');
let header = document.querySelectorAll('.accordion-header');
let item = document.querySelectorAll('.accordion-item');

header.forEach(headers => headers.addEventListener('click', toggleAccordion));
function toggleAccordion() {
    thisItem = this.parentNode;
    item.forEach(items => {
        if(thisItem == items){
            thisItem.classList.toggle('collapsed');
            return;
        }
        items.classList.remove('collapsed');
    })
}

// Menu Mobile

const navMenu = document.getElementById('nav-menu');
const navToggle = document.getElementById('nav-toggle');
const navClose = document.getElementById('nav-close');

if(navToggle){ navToggle.addEventListener('click', () => { navMenu.classList.add('show-menu')} )}
if(navClose){ navClose.addEventListener('click', () => { navMenu.classList.remove('show-menu')} )}

// Removing Menu Mobile when clicking in menu

const navLink = document.querySelectorAll('.nav-link');
function linkAction() {
    const navMenu = document.getElementById('nav-menu');
    navMenu.classList.remove('show-menu');
}
navLink.forEach(n => n.addEventListener('click', linkAction));

// Changing Background 

function scrollHeader() {
    const header = document.getElementById('header');
    if(this.scrollY >= 80) { header.classList.add('scroll-header') } else { header.classList.remove('scroll-header') };
}
window.addEventListener('scroll', scrollHeader);

// Active Link Change while scrolling

const sections = document.querySelectorAll('section[id]');

function scrollActive(){
    const scrollY = window.pageYOffset;
    sections.forEach(current => {
        const sectionHeight = current.offsetHeight;
        const sectionTop = current.offsetTop - 58;
        const sectionId = current.getAttribute('id');

        if(scrollY > sectionTop && scrollY <= sectionTop + sectionHeight){
            document.querySelector('.nav-menu a[href*=' + sectionId + ']').classList.add('active-link');
        }else{
            document.querySelector('.nav-menu a[href*=' + sectionId + ']').classList.remove('active-link');
        }
    })
}
window.addEventListener('scroll', scrollActive);
    </script>
</body>
</html>