const URI = "https://bisque-turkey-303727.hostingersite.com/Nadeen/HR/hrController.php";

$(document).ready(function () {
    drawMessagesTable();
});

function drawMessagesTable() {
    _tableUsersDetails = $('#messagesTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excelHtml5',
                title: 'Visits Details'
            },
            {
                extend: 'pdfHtml5',
                title: 'Visits Details'
            }
        ],
        proccessing: true,
        searching: true,
        lengthChange: false,
        serverSide: false,
        ajax: {
            url: URI + '?action=getUserMessages',
            type: "POST",
            data:{
                loginID:$('#loginID').val()
            },
        },
       
        order: [],
        columns: [
            {
                orderable: true,
                title: 'Subject',
                render: function (data, type, row) {
                    return row.subject;
                }
            },
            {
                orderable: true,
                title: 'Message',
                render: function (data, type, row) {
                    return row.message;
                }
            },
            {
                orderable: false,
                title: 'Action',
                render: function (data, type, row) {
                    if(row.status == 'New'){
                        return "<button class='btn btn-dark readMessage' data-id='"+row.id+"' >Mark as read</button>";    
                    }else{
                        return '<i class="fas fa-check"></i>';
                    }
                    
                }
            }
        ],
    });
}
setInterval(() => {
    _tableUsersDetails.ajax.reload();   
}, 5000);

$(document).on("click",".readMessage",function() {
    var MessageID = $(this).attr('data-id');
    $.ajax({
        type: "POST",
        url: URI+'?action=readMessage',
        data: {MessageID:MessageID},
        success: function (response) {
            $(this).remove();
        }
    });
});