// backend url used witht the ajax request
const URI = "https://nadinegp2.000webhostapp.com/Nadeen/Home/homeController.php";

// $(document).ready(function () {}) this function means that the code will be excuted in the page load
$(document).ready(function () {
    // call to a function
    getUsers();
    // $('#usersSelect').select2();
});
function getUsers() {
    // get the user select tag from the frontend by the id
    var users_Select = $("#usersSelect");
    // ajax request
    // ajax is a request sent from the frontend to the backend to do some logic
    $.ajax({
        // request type
        type: "POST",
        // request url "action" in the url will be used in the backend to know which function to execute there 
        url: URI + '?action=getUsersSelect',
        dataType: "JSON",
        success: function (response) {
            data = response.data;
            // loops on the respons recived from the backend and add them to the dropdown
            data.forEach(element => {
                users_Select.append(`<option value="${element.id}">${element.user_name}</option>`)
            });
        }
    });
}

// this function will be executed when the send button clicked
$("#sendBtn").click(function (e) {
    e.preventDefault();
    $.ajax({
        type: "POST",
        url: URI + '?action=sendMessagestoEmployee',
        data: {
            // this function will get the values for the selected users from the dropdown
            users: function () {
                var usersData = [];
                var selectedOptions = $("#usersSelect").find(":selected");

                for (let i = 0; i < Object.keys(selectedOptions).length; i++) {

                    if (selectedOptions[i]) {
                        usersData.push(selectedOptions[i].value);
                    }
                }
                return usersData;
            },
            // get the values from the input by id of each one
            sender_id: $("#senderID").val(),
            subject: $("#subject").val(),
            message: $("#message").val(),
        },
        // this function will fire when the status code of the request is 200
        success: function (response) {
            Swal.fire({
                icon: 'success',
                title: 'Great',
                text: 'Message sent successfully!',
                confirmButtonText: 'Ok',
                confirmButtonColor: 'red',
            })
        }
    });

});