const URI = "https://nadinegp2.000webhostapp.com/Nadeen/Home/homeController.php";
// function will be exexuted when the page loades
$(document).ready(function () {
    // call to a function
    drawMessagesTable();
});

function drawMessagesTable() {
    // datatable initat 
    _tableUsersDetails = $('#messagesTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excelHtml5',
                title: 'Visits Details'
            },
            {
                extend: 'pdfHtml5',
                title: 'Visits Details'
            }
        ],
        proccessing: true,
        searching: true,
        lengthChange: false,
        serverSide: false,
        // ajax request
        ajax: {
            url: URI + '?action=getUserMessages',
            type: "POST",
            data: {
                loginID: $('#loginID').val()
            },
        },

        order: [],
        // table columns
        columns: [
            {
                orderable: true,
                title: 'From',
                render: function (data, type, row) {
                    // user_name name recived from the backend
                    return row.user_name;
                }
            },
            {
                orderable: true,
                title: 'Subject',
                render: function (data, type, row) {
                    return row.subject;
                }
            },
            {
                orderable: true,
                title: 'Message',
                render: function (data, type, row) {
                    return row.message;
                }
            }
            ,
            {
                orderable: false,
                title: 'Action',
                render: function (data, type, row) {
                    if (row.status == 'New') {
                        return "<button class='btn btn-success readMessage' data-id='" + row.id + "' >Mark as read</button>";
                    } else {
                        return '<i class="fas fa-check"></i>';
                    }

                }
            }
        ],
    });
}
//  code will execute every 5 seconds 5000 means 5 seconds
setInterval(() => {
    _tableUsersDetails.ajax.reload();
}, 5000);

// mark as read button click function 
$(document).on("click", ".readMessage", function () {
    var MessageID = $(this).attr('data-id');
    // ajax request 
    $.ajax({
        type: "POST",
        url: 'https://nadinegp2.000webhostapp.com/Nadeen/HR/hrController.php?action=readMessage',
        data: { MessageID: MessageID },
        success: function (response) {
            $(this).remove();
        }
    });
});